<?php

/**
 * @file
 * Administrative page callbacks for the Mosio Support Software module.
 */

/**
 *
 * @param array $form_state
 *   structure associative drupal form array
 * @return array
 */
function mosiosupport_admin_settings_form() {
  $form['mosiosupport_account'] = array(
    '#type' => 'textfield',
    '#title' => t('Please enter your Mosio Keyword'),
    '#default_value' => variable_get('mosiosupport_account', ''),
    '#size' => 40,
    '#maxlength' => 40,
    '#required' => TRUE,
    '#description' => t('If you don\'t know your Mosio keyword, contact your administrator or email !mosiosupport.', array('!mosiosupport' => l('support@mosio.com', 'mailto:support@mosio.com'))),
  );
  
  $form['role_vis_settings'] = array(
    '#type' => 'fieldset',
    '#title' => t('Role specific script settings'),
    '#collapsible' => TRUE,
  );
  $roles = user_roles();
  $role_options = array();
  foreach ($roles as $rid => $name) {
    $role_options[$rid] = $name;
  }
  $form['role_vis_settings']['mosiosupport_roles'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Remove script for specific roles'),
    '#default_value' => variable_get('mosiosupport_roles', array()),
    '#options' => $role_options,
    '#description' => t('Remove script only for the selected role(s). If none of the roles are selected, all roles will have the script. Otherwise, any roles selected here will NOT have the script.'),
  );
  
  $form['page_vis_settings'] = array(
    '#type' => 'fieldset',
    '#title' => t('Page specific script settings'),
    '#collapsible' => TRUE,
  );
  
  $visibility = variable_get('mosiosupport_visibility', 0);
  $pages = variable_get('mosiosupport_pages', '');
  
  $options = array(t('Add to every page except the listed pages.'), t('Add to the listed pages only.'));
  $description = t("Enter one page per line as Drupal paths. The '*' character is a wildcard. Example paths are %blog for the blog page and %blog-wildcard for every personal blog. %front is the front page.", array('%blog' => 'blog', '%blog-wildcard' => 'blog/*', '%front' => '<front>'));
  $form['page_vis_settings']['mosiosupport_visibility'] = array(
    '#type' => 'radios',
    '#title' => t('Add script to specific pages'),
    '#options' => $options,
    '#default_value' => $visibility,
  );
  $form['page_vis_settings']['mosiosupport_pages'] = array(
    '#type' => 'textarea',
    '#title' => t('Pages'),
    '#default_value' => $pages,
    '#description' => $description,
    '#wysiwyg' => FALSE,
  );

  return system_settings_form($form);
}