<?php
/*
Plugin Name: Mosio Support Widget
Plugin URI: http://www.mosio.com/biz/contact
Description: This plugin makes it easy to add Mosio's Support Widget/Tab to your site by simply adding your Mosio Keyword/ID. Please make all changes and customizations to your widget within your Mosio account. After you activate the plugin, you may Enter Your Keyword <a href="options-general.php?page=mt-mosio-settings">Here</a>.
Version: 1.0
Author: Mosio
Author URI: http://www.mosio.com
*/

if ( !defined('ABSPATH') ) exit();

/* Inject HTML code in the footer hook */
add_action('wp_footer', 'qk_mosio_js');

/* Attach a menu to the settings page */
add_action('admin_menu', 'qk_mosio');
function qk_mosio() {
    add_options_page('Mosio Support Widget', 'Mosio Support Widget', 'administrator', 'mt-mosio-settings', 'qk_mosio_settings');
}


/* Inject Mosio Widget Code */
function qk_mosio_js()
{
    $op = get_option('mosio-userid'); /* Get Mosio Keyword */
    /* No need to show the embed code if there's no keyword set yet */
    if($op && !empty($op)):
    ?>
    <!-- start Mosio Support Widget -->
<div id="mosio-widget-container"></div>
<script src="https://chat.mosio.com/chat/widget.js?keyword=<?php echo $op; ?>" type="text/javascript"></script>
<!-- end Mosio Support Widget -->
    <?php
    endif;
}


/* Wp Admin Settings Page */
function qk_mosio_settings() {
?>



<div class="wrap">
        <div class="icon32" id="icon-options-general"><br></div>
        <h2>Mosio Support Widget - Settings</h2>
        <?php 
        if ($_REQUEST['updated']=='true') { 
            if(isset($_POST['mosioID']) && !empty($_POST['mosioID'])){ /* Only if there's data */
                update_option( "mosio-userid", $_POST['mosioID'] );
                echo '<div id="message" class="updated fade"><p><strong>Settings Updated</strong></p></div>';
            } 
            else
                echo '<div id="message" class="error fade"><p><strong>Missing ID!</strong></p></div>';
        }
        ?>

        <div class='updated'><p>Please type in your Mosio Keyword below.<br />If you are unsure what your keyword is, you can see it at the top of your microboard, ask your administrator or email <a href="mailto:support@mosio.com">support@mosio.com</a> and we'll help you.<br />For more information about Mosio's Simple Support software, please visit <a href="http://www.mosio.com" target="_blank">http://www.mosio.com</a></div>
    
        <div id="qk_settings-form">
            <form name="addnew" method="post" action="admin.php?page=mt-mosio-settings&amp;updated=true">
                <table class="form-table">
                    <tbody>
                        <tr valign="top">
                            <th scope="row"><label for="mosioID">Mosio Keyword or ID:</label></th>
                            <td><input name="mosioID" id="mosioID" type="text" size="45" value="<?php echo get_option('mosio-userid'); ?>" > </td>
                        </tr>
                    </tbody>
                </table>
                <p class="submit"><input type="submit" value="Save Changes" class="button-primary" name="Submit"></p>
            </form>
        </div>
</div>

<?php
}
